<?php

namespace App\Faker;


use Faker\Provider\Base;

class ClassRoomProvider extends Base
{
    protected const grades = [
        'اول',
        'دوم',
        'سوم',
        'چهارم',
        'پنجم',
        'ششم',
        'هفتم',
        'هشتم',
        'نهم',
        'دهم',
        'دهم',
        'یازدهم',
        'دوازدهم',
    ];

    protected const gradeNumbers = [
        '01',
        '02',
        '03',
        '04',
        '05',
        '06',
        '07',
        '08',
        '09',
        '10',
        '11',
        '12',
    ];

    protected const bells = [
        'اول',
        'دوم',
        'سوم',
        'چهارم',
        'پنجم',
    ];

    protected const majors = [
        'آرایش و پیرایش زنانه',
        'آرایش و پیرایش مردانه',
        'الکتروتکنیک',
        'تربیت بدنی',
        'تولید و پرورش طیور',
        'حسابداری',
        'ریاضی و فیزیک',
        'ساختمان (نازک‌کاری)',
        'شبکه و فناوری اطلاعات',
        'علوم انسانی',
        'علوم تجربی',
        'علوم و معارف اسلامی',
        'کامپیوتر (نرم‌افزار)',
        'گرافیک',
        'گردشگری',
        'معماری داخلی',
        'مکاترونیک',
        'مکانیک خودرو',
        'نقاشی ساختمان',
    ];

    protected const lessons = [
        'آزمایشگاه علوم',
        'آمادگی دفاعی',
        'انسان و محیط‌زیست',
        'انگلیسی',
        'تعلیمات ادیان و اقلیت‌ها',
        'تفکر و سبک زندگی',
        'جغرافیای ایران',
        'دین و زندگی',
        'ریاضی و آمار',
        'ریاضی',
        'سلامت و تربیت‌بدنی',
        'عربی',
        'علوم تجربی',
        'علوم و فنون ادبی',
        'فارسی',
        'فرهنگ و هنر',
        'کار و فناوری',
        'مطالعات اجتماعی',
        'نگارش',
        'هندسه',
    ];

    public function classRoom(): string
    {
        return 'کلاس ' . $this->generator->randomElement(self::grades);
    }

    public function academicLevel(): string
    {
        return 'پایه ' . $this->generator->randomElement(self::grades);
    }

    public function major(): string
    {
        return $this->generator->randomElement(self::majors);
    }

    public function bell(): string
    {
        return 'زنگ ' . $this->generator->randomElement(self::bells);
    }

    public function lesson(): string
    {
        return $this->generator->randomElement(self::lessons);
    }
}
