<?php

namespace App\Http\Middleware;

use App\Tools\CommonTools;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ResetRequest
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string $modelNames = ''): Response
    {
        $request->merge(
            CommonTools::snakeCase(
                CommonTools::toSafeHTML(
                    array_merge(
                        $request->all() ?? [],
                        $request->route()->parameters() ?? []
                    )
                )
            )
        );

        return $next($request);
    }
}
