<?php

namespace App\Http\Requests\AcademicLevel;

use App\Enums\PermissionAcademicLevelAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class DeleteAcademicLevelRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionAcademicLevelAccess::delete];

    public function rules()
    {
        return [
            'id' => ['required', 'numeric', 'exists:academic_levels,id'],
        ];
    }
}
