<?php

namespace App\Http\Requests\AcademicLevel;

use App\Enums\PermissionAcademicLevelAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class StoreAcademicLevelRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionAcademicLevelAccess::store];

    public function rules()
    {
        return [
            'academic_level.title' => [
                'required',
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
        ];
    }
}
