<?php

namespace App\Http\Requests\Auth;

use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class SignUpAuthRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [];

    public function rules()
    {
        return [
            'app' => ['boolean'],
            'user.username' => ['string', 'min:3', 'max:100', 'regex:' . Regex::usernameWithPhoneNumber, 'unique_encrypted:users,name'],
            'user.password' => ['confirmed', 'min:6'],
            'user.profile' => ['required'],
            'user.profile.first_name' => ['required', 'string', 'min:3', 'max:100', 'regex:' . Regex::alphabeticPersian],
            'user.profile.last_name' => ['required', 'string', 'min:3', 'max:100', 'regex:' . Regex::alphabeticPersian],
            'user.profile.address' => ['required', 'string', 'min:3', 'max:255', 'regex:' . Regex::alphabetic],
            'user.profile.phone' => ['required', 'string', 'min:3', 'max:12', 'regex:' . Regex::englishNumber, 'unique_encrypted:profiles,phone'],
        ];
    }
}
