<?php

namespace App\Http\Requests\Bell;

use App\Enums\PermissionBellAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class UpdateBellRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionBellAccess::update];

    public function rules()
    {

        return [
            'id' => [
                'required',
                'numeric',
                'exists:bells,id',
            ],
            'bell.title' => [
                'required',
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
            'bell.started_at' => [
                'required',
                'date_format:H:i:s',
            ],
            'bell.ended_at' => [
                'required',
                'date_format:H:i:s',
                'after:bell.started_at',
            ],
        ];
    }
}
