<?php

namespace App\Http\Requests\Grade;

use App\Enums\PermissionGradeAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class DeleteGradeRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionGradeAccess::delete,
        PermissionGradeAccess::teacherDelete
    ];

    public function rules()
    {
        return [
            'id' => ['required', 'numeric', 'exists:grades,id'],
        ];
    }
}
