<?php

namespace App\Http\Requests\Grade;

use App\Enums\PermissionGradeAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Models\User;
use App\Rules\OwnStudentWithSchoolSessionRule;
use App\Rules\SchoolSessionAccessRule;
use App\Tools\Regex;
use Throwable;

class UpdateGradeRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionGradeAccess::update,
        PermissionGradeAccess::teacherUpdate,
    ];

    public function rules()
    {
        $isNotAdmin = true;

        try {
            $isNotAdmin = !User::findOrFail(
                auth()->user()
                    ->id
            )
                ->hasPermissions(PermissionGradeAccess::store);
        } catch (Throwable $th) {
        }

        return [
            'grades' => ['required', 'array', 'min:1', 'max:100'],
            'grades.*.id' => [
                'required',
                'numeric',
                'exists:grades,id',
            ],
            'grades.*.school_session_id' => [
                'required',
                'numeric',
                'exists:school_sessions,id',
                ...($isNotAdmin ? [new SchoolSessionAccessRule()] : [])
            ],
            'grades.*.student_id' => [
                'required',
                'numeric',
                'exists:students,id',
                new OwnStudentWithSchoolSessionRule('student_id', 'grades.*.school_session_id')
            ],
            'grades.*.grade' => [
                'required',
                'min:0',
                'max:20',
                'decimal:0,20',
            ],
        ];
    }
}
