<?php

namespace App\Http\Requests\Lesson;

use App\Enums\PermissionLessonAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class ExcelStoreLessonRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionLessonAccess::store];


    public function rules()
    {
        return [
            'xlsx' => ['required', 'mimes:xlsx', 'max:10240'],
        ];
    }
}
