<?php

namespace App\Http\Requests\Major;

use App\Enums\PermissionMajorAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class DeleteMajorRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionMajorAccess::delete];

    public function rules()
    {
        return [
            'id' => ['required', 'numeric', 'exists:majors,id'],
        ];
    }
}
