<?php

namespace App\Http\Requests\Major;

use App\Enums\PermissionMajorAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class ExcelStoreMajorRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionMajorAccess::store];


    public function rules()
    {
        return [
            'xlsx' => ['required', 'mimes:xlsx', 'max:10240'],
        ];
    }
}
