<?php

namespace App\Http\Requests\Model;

use App\Models\User;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;

class ModelBaseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    protected $authorizePermissions = [];
    protected $rules = [];
    protected $messages = [];

    public function authorize()
    {
        if (count($this->authorizePermissions) > 0) {
            try {
                $user = User::findOrFail(auth()->id());
                return $user->hasPermissions($this->getPermissionUsedString());
            } catch (\Throwable $th) {
                return false;
            }
        } else {
            return true;
        }
    }

    public function getPermissionUsedString()
    {
        return array_map(function ($per) {
            return $per->value;
        }, $this->authorizePermissions);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return $this->rules;
    }

    public function messages()
    {
        return $this->messages;
    }

    protected function failedValidation(Validator $validator)
    {
        // $this->__validator = $validator;
        $this->setValidator($validator);
    }

    public function fails()
    {
        return $this->validator->fails();
    }

    public function firstError()
    {
        return $this->validator
            ->errors()
            ->first();
    }

    public function errorsToArray()
    {
        return $this->validator
            ->errors()
            ->toArray();
    }
}
