<?php

namespace App\Http\Requests\Presence;

use App\Enums\PermissionPresenceAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class SendSmsPresenceRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionPresenceAccess::sendSms
    ];

    public function rules()
    {
        return [
            'presence_ids' => [
                'required',
                'array',
                'min:1',
                'max:200'
            ],
            'presence_ids.*' => [
                'required',
                'numeric',
                'distinct',
                'exists:presences,id'
            ],
            'message' => [
                'required',
                'string',
                'min:3',
                'max:255'
            ]
        ];
    }
}
