<?php

namespace App\Http\Requests\Presence;

use App\Enums\PermissionPresenceAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Rules\OwnStudentWithSchoolSessionRule;
use App\Tools\Regex;

class UpdatePresenceRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionPresenceAccess::update,
        PermissionPresenceAccess::selfUpdate
    ];

    public function rules()
    {
        return [
            'presence.school_session_id' => [
                'required',
                'numeric',
                'exists:school_sessions,id'
            ],

            'presence.students' => [
                'array',
                'min:1',
                'max:200'
            ],
            'presence.students.*.student_id' => [
                'required',
                'numeric',
                'distinct',
                'exists:students,id',
                new OwnStudentWithSchoolSessionRule(
                    'student_id',
                    'presence.school_session_id'
                )
            ],
            'presence.students.*.status' => [
                'required',
                'boolean'
            ],

            'presence.students.*.entry_time' => [
                'prohibited_unless:presence.students.*.status,1',
                'date_format:H:i:s',
            ],
            'presence.students.*.exit_time' => [
                'prohibited_unless:presence.students.*.status,1',
                'date_format:H:i:s',
            ],
            'presence.students.*.delay_reason' => [
                'prohibited_unless:presence.students.*.status,1',
                'string',
                'min:3',
                'max:700',
                'regex:' . Regex::alphabetic
            ],
            'presence.students.*.early_exit_reason' => [
                'prohibited_unless:presence.students.*.status,1',
                'string',
                'min:3',
                'max:700',
                'regex:' . Regex::alphabetic
            ],
        ];
    }
}
