<?php

namespace App\Http\Requests\Role;

use App\Enums\PermissionAccess;
use App\Enums\PermissionRoleAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Models\Role;
use App\Tools\CommonTools;

class DeleteRoleRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionRoleAccess::delete];

    public function rules()
    {
        $roleIds = '1';

        if (!(auth()->user()->id === 1)) {
            $roleIds = Role::select(['id'])
                ->whereIn('name', CommonTools::enumToArray(PermissionAccess::class))
                ->pluck('id')
                ->join(',');
        }

        return [
            'id' => ['required', 'numeric', "not_in:$roleIds", 'exists:roles,id'],
        ];
    }
}
