<?php

namespace App\Http\Requests\Role;

use App\Enums\PermissionAccess;
use App\Enums\PermissionRoleAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Models\Role;
use App\Tools\CommonTools;
use App\Tools\Regex;

class UpdateRoleRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionRoleAccess::update];

    public function rules()
    {
        $roleIds = '1';

        if (!(auth()->user()->id === 1)) {
            $roleIds = Role::select(['id'])
                ->whereIn('name', CommonTools::enumToArray(PermissionAccess::class))
                ->pluck('id')
                ->join(',');
        }

        return [
            'id' => ['required', 'numeric', "not_in:$roleIds", 'exists:roles,id'],
            'role.name' => ['required', 'string', 'min:3', 'max:60', 'regex:' . Regex::english],
            'role.title' => ['required', 'string', 'min:3', 'max:120', 'regex:' . Regex::alphabeticPersian],
            'role.permissions' => ['required', 'array', 'min:1'],
            'role.permissions.*' => ['required', 'numeric', 'exists:permissions,id'],
        ];
    }
}
