<?php

namespace App\Http\Requests\SchoolSession;

use App\Enums\PermissionSchoolSessionAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class DeleteSchoolSessionRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionSchoolSessionAccess::delete,
        PermissionSchoolSessionAccess::selfDelete
    ];

    public function rules()
    {
        return [
            'id' => ['required', 'numeric', 'exists:school_sessions,id'],
        ];
    }
}
