<?php

namespace App\Http\Requests\Student;

use App\Enums\PermissionStudentAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class ExcelStoreStudentRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionStudentAccess::store];


    public function rules()
    {
        return [
            'xlsx' => ['required', 'mimes:xlsx', 'max:10240'],
        ];
    }
}
