<?php

namespace App\Http\Requests\Student;

use App\Enums\PermissionStudentAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class PrivateStorageStudentRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionStudentAccess::view,
        PermissionStudentAccess::teacherView,
    ];


    public function rules()
    {
        return [
            'dir' => [
                'required',
                'string',
                'min:2',
                'max:100',
                'regex:' . Regex::dir
            ],
            'filename' => [
                'required',
                'string',
                'min:4',
                'max:200',
                'regex:' . Regex::fileName
            ],
        ];
    }
}
