<?php

namespace App\Http\Requests\Student;

use App\Enums\PermissionStudentAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Rules\NationalCodeRule;
use App\Tools\Regex;

class StoreStudentRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionStudentAccess::store];

    public function rules()
    {
        return [
            'student.class_room_id' => [
                'numeric',
                'exists:class_rooms,id',
            ],
            'student.parent_id' => [
                'required',
                'numeric',
                'exists:users,id',
            ],
            'student.first_name' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::alphabeticPersian
            ],
            'student.last_name' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::alphabeticPersian
            ],
            'student.national_code' => [
                'required',
                'string',
                'max:10',
                new NationalCodeRule(),
                'unique_encrypted:students,national_code'
            ],
            'student.image' => [
                'mimes:jpeg,jpg,png,webp,avif',
                'max:1024'
            ],
        ];
    }
}
