<?php

namespace App\Http\Requests\Student;

use App\Enums\PermissionStudentAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Rules\NationalCodeRule;
use App\Tools\CommonTools;
use App\Tools\Regex;

class UpdateStudentRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionStudentAccess::update];

    public function rules()
    {
        $studentId = -1;

        try {
            $studentId = intval(CommonTools::toSafeHTML($this->get('id')));
        } catch (\Throwable $th) {
            //throw $th;
        }

        return [
            'id' => [
                'required',
                'numeric',
                'exists:students,id',
            ],
            'student.class_room_id' => [
                'numeric',
                'exists:class_rooms,id',
            ],
            'student.parent_id' => [
                'required',
                'numeric',
                'exists:users,id',
            ],
            'student.first_name' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::alphabeticPersian
            ],
            'student.last_name' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::alphabeticPersian
            ],
            'student.national_code' => [
                'required',
                'string',
                'max:10',
                new NationalCodeRule(),
                "unique_encrypted:students,national_code,$studentId"
            ],
            'student.image' => [
                'mimes:jpeg,jpg,png,webp,avif',
                'max:1024'
            ],
            'student.delete_class_room_ids' => [
                'array',
                'min:1',
                'max:10',
                'distinct',
            ],
            'student.delete_class_room_ids.*' => [
                'numeric',
                'exists:class_rooms,id',
            ],
        ];
    }
}
