<?php

namespace App\Http\Requests\Teacher;

use App\Enums\PermissionTeacherAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class ExcelStoreTeacherRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionTeacherAccess::store];


    public function rules()
    {
        return [
            'xlsx' => ['required', 'mimes:xlsx', 'max:10240'],
        ];
    }
}
