<?php

namespace App\Http\Requests\User;

use App\Enums\PermissionUserAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class ChangeUserPasswordRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionUserAccess::selfUpdate];


    public function rules()
    {
        return [
            'user.current_password' => ['min:6', 'max:20'],
            'user.password' => ['confirmed', 'min:6', 'max:20'],
        ];
    }
}
