<?php

namespace App\Http\Requests\WeeklySchedule;

use App\Enums\PermissionWeeklyScheduleAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class DeleteWeeklyScheduleRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionWeeklyScheduleAccess::delete];

    public function rules()
    {
        return [
            'id' => ['required', 'numeric', 'exists:weekly_schedules,id'],
        ];
    }
}
