<?php

namespace App\Imports;

use App\Exceptions\AnyException;
use App\Http\Controllers\UserController;
use App\Rules\NationalCodeRule;
use App\Tools\Regex;
use Arr;
use Illuminate\Support\Collection;
use Log;
use Maatwebsite\Excel\Concerns\PersistRelations;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithValidation;

class TeacherImport implements ToCollection, WithValidation, WithHeadingRow, WithMapping, PersistRelations
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $collection)
    {

        $file = null;
        foreach ($collection as $row) {
            $teacherAdd = $row['teacher'];

            [$user, $password] = UserController::createUser(
                $teacherAdd['user'],
                $file,
                'teacher'
            );

            $user->teacher()->create([
                'personally_code' => $teacherAdd['personally_code']
            ]);
        }
    }


    public function map($row): array
    {
        try {
            $phone = strval($row['phone']);

            if (strlen($phone) > 0 && $phone[0] != '0') {
                $phone = "0$phone";
            }

            return  Arr::undot([
                'teacher.personally_code' => strval($row['personally_code']),
                'teacher.user.name' => 'teacher_' . strval($row['personally_code']),
                'teacher.user.password' => strval($row['national_code']),
                'teacher.user.active' => strval($row['active']),
                'teacher.user.profile.address' => $row['address'],
                'teacher.user.profile.first_name' => $row['first_name'],
                'teacher.user.profile.last_name' => $row['last_name'],
                'teacher.user.profile.national_code' => strval($row['national_code']),
                'teacher.user.profile.phone' => $phone,
            ]);
        } catch (\Throwable $th) {
            //throw $th;
        }

        throw new AnyException(__('messages.error_excel_parse_row'));
    }


    public function rules(): array
    {

        return [
            '*.teacher.personally_code' => [
                'required',
                'string',
                'min:6',
                'max:120',
                "unique_encrypted:teachers,personally_code"
            ],
            '*.teacher.user.active' => ['in:0,1,2'],
            '*.teacher.user.profile.first_name' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::alphabeticPersian
            ],
            '*.teacher.user.profile.last_name' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::alphabeticPersian
            ],
            '*.teacher.user.profile.national_code' => [
                'required',
                'string',
                'max:10',
                new NationalCodeRule(),
                "unique_encrypted:profiles,national_code"
            ],
            '*.teacher.user.profile.address' => [
                'required',
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
            '*.teacher.user.profile.phone' => [
                'required',
                'string',
                'min:3',
                'max:12',
                'regex:' . Regex::englishNumber,
                "unique_encrypted:profiles,phone"
            ],
            '*.teacher.user.name' => [
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::username,
                'unique_encrypted:users,name'
            ],
        ];
    }
}
