<?php

namespace App\Jobs;

use App\Models\Log;
use App\Tools\CommonTools;
use Carbon\Carbon;
use DB;

class RemoveLogJob
{

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            DB::transaction(function () {

                Log::whereDate(
                    'created_at',
                    '<',
                    Carbon::now()
                        ->addMonths(-1)
                        ->startOfDay()
                        ->format("Y-m-d H:i:s")
                )
                    ->delete();
            });
        } catch (\Throwable $th) {
            CommonTools::registerException($th, 'RemoveDownloadKeyJob');
        }
    }
}
