<?php

namespace App\Models;

use App\Casts\Json;
use App\Traits\EncryptedAttribute;

class ApplicationConfig extends BaseModel
{
    use  EncryptedAttribute;

    public $timestamps = true;

    protected $encryptable = [
        'title',
        'value',
    ];

    protected $encryptableCast = [
        'value' => Json::class,
    ];

    protected $fillable = [
        'title',
        'active',
        'is_private',
        'level',
        'value',
    ];

    protected $casts = [
        'active' => 'boolean',
        'is_private' => 'boolean'
    ];
}
