<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class ClassRoom extends BaseModel
{
    use HasFactory;

    public $timestamps = true;

    protected $fillable = [
        'academic_level_id',
        'code',
        'major_id',
        'title',
    ];

    protected $casts = [
        'academic_level_id' => 'int',
        'major_id' => 'int',
    ];

    protected $hidden = [
        'laravel_through_key'
    ];


    public function academicLevel()
    {
        return $this->belongsTo(AcademicLevel::class);
    }

    public function major()
    {
        return $this->belongsTo(Major::class);
    }

    public function lessons()
    {
        return $this->hasMany(Lesson::class);
    }

    public function students()
    {
        return $this->belongsToMany(Student::class)
            ->using(ClassRoomStudent::class)
            ->withTimestamps();
    }

    public function weeklySchedules()
    {
        return $this->hasMany(WeeklySchedule::class);
    }
}
