<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\Pivot;

class ClassRoomStudent extends Pivot
{
    use HasFactory;
    protected $fillable = ['class_room_id', 'student_id'];

    protected $casts = [
        'class_room_id' => 'int',
        'student_id' => 'int',
    ];

    public function classRooms()
    {
        return $this->belongsToMany(ClassRoom::class)
            ->using(ClassRoomStudent::class)
            ->withTimestamps();
    }
}
