<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class Grade extends BaseModel
{
    use HasFactory;

    public $timestamps = true;


    protected $fillable = [
        'grade',
        'lesson_id',
        'school_session_id',
        'sms_sended_at',
        'student_id',
    ];

    protected $casts = [
        'grade' => 'float',
        'lesson_id' => 'int',
        'school_session_id' => 'int',
        'student_id' => 'int',
    ];

    protected $dates = [
        'sms_sended_at',
    ];


    public function schoolSession()
    {
        return $this->belongsTo(SchoolSession::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function lesson()
    {
        return $this->belongsTo(Lesson::class);
    }

    public function teacher()
    {
        return $this->hasOneThrough(
            User::class,
            SchoolSession::class,
            'school_sessions.id',
            'users.id',
            'school_session_id',
            'teacher_user_id'
        );
    }
}
