<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class Image extends BaseModel
{
    use HasFactory;

    static $EXTRA_IMAGE_USER = 100000;
    static $EXTRA_IMAGE_USER_PROFILE = 100001;

    protected $fillable = ['imageable_id', 'name', 'imageable_type', 'extra'];
    protected $hidden = ['imageable_id', 'imageable_type', 'created_at', 'updated_at'];

    protected $casts = [
        'imageable_id' => 'int',
    ];

    public function imageable()
    {
        return $this->morphTo();
    }
}
