<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class Lesson extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'class_room_id',
        'is_podmany',
        'passing_grade',
        'title',
    ];

    protected $casts = [
        'class_room_id' => 'int',
        'is_podmany' => 'boolean',
        'passing_grade' => 'int',
    ];

    public function classRoom()
    {
        return $this->belongsTo(ClassRoom::class);
    }

    public function weeklySchedules()
    {
        return $this->hasMany(
            WeeklySchedule::class,
            'class_room_id',
            'class_room_id',
        );
    }

    public function schoolSessions()
    {
        return $this->hasManyThrough(
            SchoolSession::class,
            WeeklySchedule::class,
            'class_room_id',
            'weekly_schedule_id',
            'class_room_id',
            'id',
        );
    }
}
