<?php

namespace App\Models;

use App\Traits\EncryptedAttribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class Moral extends BaseModel
{
    use HasFactory, EncryptedAttribute, HasRelationships;

    public $timestamps = true;

    protected $encryptable = [
        'comment',
    ];

    protected $fillable = [
        'comment',
        'moral',
        'school_session_id',
        'sms_sended_at',
        'student_id',
    ];

    protected $appends = [
        'class_room_id'
    ];

    protected $casts = [
        'moral' => 'int',
        'school_session_id' => 'int',
        'student_id' => 'int',
    ];

    protected $dates = [
        'sms_sended_at',
    ];


    public function schoolSession()
    {
        return $this->belongsTo(SchoolSession::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function bell()
    {
        return $this->hasOneDeep(
            Bell::class,
            [SchoolSession::class, WeeklySchedule::class],
            ['id', 'id', 'id'],
            ['school_session_id', 'weekly_schedule_id', 'bell_id']
        );
    }

    public function classRoom()
    {
        return $this->hasOneDeep(
            ClassRoom::class,
            [SchoolSession::class, WeeklySchedule::class],
            ['id', 'id', 'id'],
            ['school_session_id', 'weekly_schedule_id', 'class_room_id']
        );
    }

    public function lesson()
    {
        return $this->hasOneDeep(
            Lesson::class,
            [SchoolSession::class, WeeklySchedule::class],
            ['id', 'id', 'id'],
            ['school_session_id', 'weekly_schedule_id', 'lesson_id']
        );
    }

    public function getClassRoomIdAttribute()
    {
        return optional(
            $this->classRoom()
                ->first()
        )
            ->id ?? null;
    }
}
