<?php

namespace App\Models;

class Permission extends BaseModel
{
    protected $hidden = ['pivot'];
    protected $fillable = ['id'];
    protected $maps = [
        'id' => 'id',
        'name' => 'name',
        'title' => 'title',
    ];

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'role_permission')
            ->using(RolePermission::class)->withTimestamps();
    }
}