<?php

namespace App\Models;

class Role extends BaseModel
{
    protected $hidden = ['pivot', 'laravel_through_key'];
    protected $fillable = ['name', 'title'];

    public function users()
    {
        return $this->belongsToMany(User::class, 'user_role')
            ->using(UserRole::class)->withPivot('primary')->withTimestamps();
    }

    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'role_permission')
            ->using(RolePermission::class)->withTimestamps();
    }
}
