<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class WeeklySchedule extends BaseModel
{
    use HasFactory;

    public $timestamps = true;

    protected $fillable = [
        'bell_id',
        'bell_type',
        'class_room_id',
        'day',
        'lesson_id',
        'teacher_id',
    ];

    protected $casts = [
        'bell_id' => 'int',
        'class_room_id' => 'int',
        'day' => 'int',
        'lesson_id' => 'int',
        'teacher_id' => 'int',
    ];


    public function bell()
    {
        return $this->belongsTo(Bell::class);
    }

    public function classRoom()
    {
        return $this->belongsTo(ClassRoom::class);
    }

    public function lesson()
    {
        return $this->belongsTo(Lesson::class);
    }

    public function teacher()
    {
        return $this->belongsTo(User::class);
    }

    public function schoolSessions()
    {
        return $this->hasMany(SchoolSession::class);
    }
}
