<?php

namespace App\Providers;

use App\Faker\ClassRoomProvider;
use Faker\Factory;
use Faker\Generator;
use Illuminate\Support\ServiceProvider;
use Log;

class FakerServiceProvider extends ServiceProvider
{
    public function register(): void
    {

        if (!$this->app->environment(['local', 'testing'])) {
            return;
        }

        $this->app->singleton(
            abstract: Generator::class,
            concrete: function (): Generator {
                $factory = Factory::create(config('app.faker_locale'));

                $factory->addProvider(new ClassRoomProvider($factory));

                return $factory;
            }
        );

        $this->app->bind(
            abstract: Generator::class . ':' . config('app.faker_locale'),
            concrete: Generator::class
        );
    }

    public function boot(): void {}
}
