<?php

namespace App\Rules;

use App\Tools\CommonTools;
use Closure;
use Exception;
use Illuminate\Contracts\Validation\ValidationRule;

class NationalCodeRule implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string, ?string=): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $isPass = true;
        try {
            if (!preg_match('/^[0-9]{10}$/', $value)) {
                $isPass = false;
            }

            if ($isPass) {
                for ($i = 0; $i < 10; $i++) {
                    if (preg_match('/^' . $i . '{10}$/', $value)) {
                        $isPass = false;
                    }
                }
            }

            if ($isPass) {
                for ($i = 0, $sum = 0; $i < 9; $i++) {
                    $sum += ((10 - $i) * (int)substr($value, $i, 1));
                }
                $ret = $sum % 11;
                $parity = (int)substr($value, 9, 1);
                $isPass = ($ret < 2 && $ret == $parity) || ($ret >= 2 && $ret == 11 - $parity);
            }
        } catch (Exception $exception) {
            $isPass = false;
            CommonTools::registerException($exception->getMessage(), "NationalCodeRule");
        }

        if ($isPass == true) {
            return;
        }

        $fail('validation.national_code')
            ->translate([
                'attribute' => __(
                    'validation.attributes',
                )[preg_replace('/\.\d+$/', '.*', $attribute)] ?? $attribute
            ]);
    }
}
