<?php

namespace App\Rules;

use App\Models\SchoolSession;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Throwable;

class SchoolSessionAccessRule implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string, ?string=): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {

        $exists = SchoolSession::where('id', '=', $value)
            ->where(
                'teacher_user_id',
                '=',
                auth()->user()->id
            )
            ->exists();

        if ($exists == true) {
            return;
        }

        $fail('validation.school_session_access')
            ->translate([
                'attribute' => __(
                    'validation.attributes',
                )[preg_replace('/\.\d+$/', '.*', $attribute)] ?? $attribute,
                'value' => $value
            ]);
    }
}
