<?php

namespace App\Tools;


class NumericTools
{
    static $numbers = [
        '0' => '۰',
        '1' => '۱',
        '2' => '۲',
        '3' => '۳',
        '4' => '۴',
        '5' => '۵',
        '6' => '۶',
        '7' => '۷',
        '8' => '۸',
        '9' => '۹',
    ];

    public static function enToFa($str)
    {
        return str_replace(
            array_keys(self::$numbers),
            array_values(self::$numbers),
            $str
        );
    }

    public static function formatPersianPrice($text)
    {
        return number_format($text, 0, '.', ',');
    }
}
