<?php

namespace App\Tools;

use ErrorException;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use InvalidArgumentException;

class RandomGenerator
{
    private const HASH = 'md5';

    /**
     * @param string $path ="", "app\", ...
     * @param int $maxHop
     * @return string
     *
     * @throws ErrorException
     */
    public static function filename(string $path = "", int $maxHop = 3): string
    {
        $index = 0;
        do {
            $name = hash(self::HASH, sprintf('%s%s', self::password(), time()));
            if (!Storage::exists($path . $name)) {
                return $name;
            }
            $index = $index + 1;
        } while ($index < $maxHop);

        throw new ErrorException("exist file");
    }

    public static function password($max_length = 6)
    {
        return Str::random($max_length);
    }

    public static function username()
    {
        return Str::uuid();
    }

    public static function verificationToken($max_length = 6)
    {
        $max = $max_length;
        $characters = '0123456789';
        $randstring = '';
        for ($i = 0; $i < $max; $i++) {
            $randstring .= $characters[rand(0, strlen($characters) - 1)];
        }
        return $randstring;
    }

    public static function generateRandomFloat(float $min, float $max, $decimal = 5): float
    {
        if ($min > $max) {
            throw new InvalidArgumentException("Min value ($min) must be less than max value ($max)");
        }

        $tmp = pow(10, $decimal);

        $randomInt = mt_rand((int) ($min * $tmp), (int) ($max * $tmp));

        return $randomInt / ($tmp * 1.0);
    }
}