<?php

namespace App\Tools;

use Arr;
use Exception;
use Str;

class SmsTools
{

    /**
     * send sms with variables like :parent_full_name
     * @param \Illuminate\Support\Collection<int,string>|\Illuminate\Support\Collection<string,array> $phones 
     * @param mixed $message
     * @return void
     */
    public static function sendFormatSms($phones, $message)
    {
        if (!self::hasVariables($message)) {
            return;
        }

        if (Arr::isList($phones->toArray())) {
            throw new Exception('phones is list');
        }

        $vars = self::getVariables($message);

        foreach ($phones as $phone => $values) {
            $messageFormat = Str::replace(
                $vars->toArray(),
                $vars->map(
                    fn($var) => $values[$var] ?? '-'
                ),
                $message
            );
        }
    }

    public static function hasVariables($message)
    {
        return self::getVariables($message)->count() > 0;
    }

    public static function getVariables($message)
    {
        return Str::matchAll('/(?<=^| ):[a-z_]+(?=$|\s)/', $message);
    }
}
