<?php

namespace App\View\Components;

use Carbon\Carbon;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use Morilog\Jalali\Jalalian;

class DailyReportPresencesAndMoralsReport extends Component
{
    public $reportInfo = null;
    public $presences = null;
    public $morals = null;
    public $bells = null;
    public $date = null;


    /**
     * Create a new component instance.
     */
    public function __construct(
        $reportInfo,
        $presences,
        $morals,
        $bells,
        $date,
    ) {
        $this->reportInfo = $reportInfo;
        $this->presences = $presences;
        $this->morals = $morals;
        $this->bells = $bells;

        $this->date = Jalalian::fromCarbon($date)->format('Y/m/d');
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.daily-report-presences-and-morals-report.daily-report-presences-and-morals-report');
    }

    public function fullName($model)
    {
        return ($model['first_name'] ?? '') . ' ' . ($model['last_name'] ?? '');
    }

    public function formatHour($hour)
    {
        if (!$hour) {
            return '-';
        }

        return Carbon::createFromFormat('H:m:s', $hour)->format('H:m');
    }

    public function getBell($bellId)
    {
        return $this->bells->find($bellId);
    }

    public function getMoralStatusString($moral)
    {
        switch ($moral['moral']) {
            case 0:
                return 'بسیار بد';
            case 1:
                return 'بد';
            case 2:
                return 'متوسط';
            case 3:
                return 'خوب';
            case 4:
                return 'خیلی خوب';
            case 5:
                return 'عالی';
            default:
                return '-';
        }
    }
}
