<?php

namespace App\View\Components;

use Carbon\Carbon;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use Morilog\Jalali\Jalalian;

class PresenceReport extends Component
{
    public $reportInfo = null;
    public $presences = null;
    public $firstPresence = null;
    public $lastPresence = null;


    /**
     * Create a new component instance.
     */
    public function __construct(
        $reportInfo,
        $presences,
        $firstPresence,
        $lastPresence
    ) {
        $this->reportInfo = $reportInfo;
        $this->presences = $presences;
        $this->firstPresence = $firstPresence;
        $this->lastPresence = $lastPresence;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.presence-report');
    }

    /**
     * format dataTime to H:i
     * * @param string|null $timeString
     * @return string
     */
    public function formatTime($timeString)
    {
        if (empty($timeString) || $timeString === '-') {
            return '-';
        }

        try {
            return Carbon::parse($timeString)->format('H:i');
        } catch (\Exception $e) {
            return '-';
        }
    }

    public function presenceStartedAt()
    {
        if (
            !isset($this->firstPresence) ||
            !isset($this->firstPresence->created_at)
        ) {
            return '-';
        }

        return Jalalian::fromCarbon($this->firstPresence->created_at)
            ->format('Y/m/d');
    }

    public function presenceEndedAt()
    {
        if (
            !isset($this->lastPresence) ||
            !isset($this->lastPresence->created_at)
        ) {
            return '-';
        }
        return Jalalian::fromCarbon($this->lastPresence->created_at)
            ->format('Y/m/d');
    }
}
