<?php

namespace App\View\Components;

use Arr;
use Carbon\Carbon;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class TeachingReportsReport extends Component
{
    public $reportInfo = null;
    public $term = null;
    public $year = null;
    public $studentGrades = null;


    /**
     * Create a new component instance.
     */
    public function __construct(
        $reportInfo,
        $term,
        $year,
        $studentGrades,
    ) {
        $this->reportInfo = $reportInfo;
        $this->term = $term;
        $this->year = intval($year);
        $this->studentGrades = $studentGrades;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.teaching-reports-report.teaching-reports-report');
    }

    /**
     * format dataTime to H:i
     * * @param string|null $timeString
     * @return string
     */
    public function formatTime($timeString)
    {
        if (empty($timeString) || $timeString === '-') {
            return '-';
        }

        try {
            return Carbon::parse($timeString)->format('H:i');
        } catch (\Exception $e) {
            return '-';
        }
    }


    public function fullName($model)
    {
        return ($model['first_name'] ?? '') . ' ' . ($model['last_name'] ?? '');
    }

    public function fullNameTeachers($lesson)
    {

        if (!isset($lesson['teachers']) || count($lesson['teachers']) == 0) {
            return '-';
        }

        return Arr::join(
            Arr::map(
                $lesson['teachers'],
                fn($el) => $this->fullName($el['profile'])
            ),
            '، '
        );
    }

    public function passingLesson($teachingReport)
    {
        return intval($teachingReport['final_grade']) >= intval($teachingReport['lesson']['passing_grade']);
    }

    public function finalGrade($teachingReports)
    {
        return number_format(
            array_sum(Arr::pluck($teachingReports, 'final_grade')) / count($teachingReports),
            2
        );
    }

    public function fatherName($student)
    {
        return data_get($student, 'student_parent.profile.first_name', '-');
    }

    public function getYear()
    {
        return sprintf('%s-%s', $this->year, $this->year - 1);
    }

    public function getTerm()
    {
        switch ($this->term) {
            case 1:
                return 'اول';

            case 2:
                return 'دوم';

            case 3:
                return 'تابستانه';

            default:
                return '-';
        }
    }
}
