<?php

namespace App\View\Components;

use Arr;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class WeeklySchedulesReport extends Component
{
    public  $dayOfWeek = ['شنبه', 'یکشنبه', 'دوشنبه', 'سه‌شنبه', 'چهارشنبه', 'پنجشنبه', 'جمعه'];
    public $reportInfo = null;
    public $bells = null;
    public $year = null;
    public $weeklySchedules = null;


    /**
     * Create a new component instance.
     */
    public function __construct(
        $reportInfo,
        $bells,
        $year,
        $weeklySchedules,
    ) {
        $this->reportInfo = $reportInfo;
        $this->bells = $bells;
        $this->year = intval($year);
        $this->weeklySchedules = $weeklySchedules;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.weekly-schedules-report.weekly-schedules-report');
    }

    public function fullName($model)
    {
        return Arr::join(
            Arr::map(
                Arr::pluck(
                    $model,
                    'teacher.profile'
                ),
                fn($el) => ($el['first_name'] ?? '') . ' ' . ($el['last_name'] ?? '')
            ),
            '،'
        );
    }

    public function getSchoolInformation()
    {
        return sprintf(
            'برنامه هفتگی مدرسه %s(%s) / استان %s / ناحیه %s / %s / %s-%s',
            $this->reportInfo['school_title'] ?? '-',
            $this->reportInfo['school_code'] ?? '-',
            $this->reportInfo['school_province'] ?? '-',
            $this->reportInfo['school_district'] ?? '-',
            $this->reportInfo['school_type'] ?? '-',
            $this->year,
            $this->year - 1
        );
    }
}
