<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'فیلد :attribute باید پذیرفته شود.',
    'accepted_if' => 'فیلد :attribute باید پذیرفته شود وقتی :other برابر با :value باشد.',
    'active_url' => 'فیلد :attribute باید یک URL معتبر باشد.',
    'after' => 'فیلد :attribute باید تاریخی بعد از :date باشد.',
    'after_or_equal' => 'فیلد :attribute باید تاریخی بعد یا برابر با :date باشد.',
    'alpha' => 'فیلد :attribute فقط باید شامل حروف باشد.',
    'alpha_dash' => 'فیلد :attribute فقط باید شامل حروف، اعداد، خط تیره و زیرخط باشد.',
    'alpha_num' => 'فیلد :attribute فقط باید شامل حروف و اعداد باشد.',
    'array' => 'فیلد :attribute باید یک آرایه باشد.',
    'ascii' => 'فیلد :attribute فقط باید شامل کاراکترها و نمادهای تک‌بایتی باشد.',
    'before' => 'فیلد :attribute باید تاریخی قبل از :date باشد.',
    'before_or_equal' => 'فیلد :attribute باید تاریخی قبل یا برابر با :date باشد.',
    'between' => [
        'array' => 'فیلد :attribute باید بین :min و :max آیتم داشته باشد.',
        'file' => 'فیلد :attribute باید بین :min و :max کیلوبایت باشد.',
        'numeric' => 'فیلد :attribute باید بین :min و :max باشد.',
        'string' => 'فیلد :attribute باید بین :min و :max کاراکتر باشد.',
    ],
    'boolean' => 'فیلد :attribute باید درست یا نادرست باشد.',
    'can' => 'فیلد :attribute شامل مقداری غیرمجاز است.',
    'confirmed' => 'تأیید فیلد :attribute مطابقت ندارد.',
    'contains' => 'فیلد :attribute مقدار مورد نیاز را ندارد.',
    'current_password' => 'رمز عبور نادرست است.',
    'date' => 'فیلد :attribute باید یک تاریخ معتبر باشد.',
    'date_equals' => 'فیلد :attribute باید تاریخی برابر با :date باشد.',
    'date_format' => 'فیلد :attribute باید با فرمت :format مطابقت داشته باشد.',
    'decimal' => 'فیلد :attribute باید :decimal رقم اعشاری داشته باشد.',
    'declined' => 'فیلد :attribute باید رد شود.',
    'declined_if' => 'فیلد :attribute باید رد شود وقتی :other برابر با :value باشد.',
    'different' => 'فیلد :attribute و :other باید متفاوت باشند.',
    'digits' => 'فیلد :attribute باید :digits رقم باشد.',
    'digits_between' => 'فیلد :attribute باید بین :min و :max رقم باشد.',
    'dimensions' => 'فیلد :attribute ابعاد تصویر نامعتبری دارد.',
    'distinct' => 'فیلد :attribute مقدار تکراری دارد.',
    'doesnt_end_with' => 'فیلد :attribute نباید با یکی از موارد زیر پایان یابد: :values.',
    'doesnt_start_with' => 'فیلد :attribute نباید با یکی از موارد زیر شروع شود: :values.',
    'email' => 'فیلد :attribute باید یک آدرس ایمیل معتبر باشد.',
    'ends_with' => 'فیلد :attribute باید با یکی از موارد زیر پایان یابد: :values.',
    'enum' => 'مقدار انتخاب‌شده برای :attribute نامعتبر است.',
    'exists' => 'مقدار انتخاب‌شده برای :attribute نامعتبر است.',
    'extensions' => 'فیلد :attribute باید یکی از پسوندهای زیر را داشته باشد: :values.',
    'file' => 'فیلد :attribute باید یک فایل باشد.',
    'filled' => 'فیلد :attribute باید مقدار داشته باشد.',
    'gt' => [
        'array' => 'فیلد :attribute باید بیش از :value آیتم داشته باشد.',
        'file' => 'فیلد :attribute باید بزرگ‌تر از :value کیلوبایت باشد.',
        'numeric' => 'فیلد :attribute باید بزرگ‌تر از :value باشد.',
        'string' => 'فیلد :attribute باید بیش از :value کاراکتر داشته باشد.',
    ],
    'gte' => [
        'array' => 'فیلد :attribute باید :value آیتم یا بیشتر داشته باشد.',
        'file' => 'فیلد :attribute باید بزرگ‌تر یا برابر با :value کیلوبایت باشد.',
        'numeric' => 'فیلد :attribute باید بزرگ‌تر یا برابر با :value باشد.',
        'string' => 'فیلد :attribute باید بزرگ‌تر یا برابر با :value کاراکتر باشد.',
    ],
    'hex_color' => 'فیلد :attribute باید یک رنگ هگزادسیمال معتبر باشد.',
    'image' => 'فیلد :attribute باید یک تصویر باشد.',
    'in' => 'مقدار انتخاب‌شده برای :attribute نامعتبر است.',
    'in_array' => 'فیلد :attribute باید در :other وجود داشته باشد.',
    'integer' => 'فیلد :attribute باید یک عدد صحیح باشد.',
    'ip' => 'فیلد :attribute باید یک آدرس IP معتبر باشد.',
    'ipv4' => 'فیلد :attribute باید یک آدرس IPv4 معتبر باشد.',
    'ipv6' => 'فیلد :attribute باید یک آدرس IPv6 معتبر باشد.',
    'json' => 'فیلد :attribute باید یک رشته JSON معتبر باشد.',
    'list' => 'فیلد :attribute باید یک لیست باشد.',
    'lowercase' => 'فیلد :attribute باید با حروف کوچک باشد.',
    'lt' => [
        'array' => 'فیلد :attribute باید کمتر از :value آیتم داشته باشد.',
        'file' => 'فیلد :attribute باید کمتر از :value کیلوبایت باشد.',
        'numeric' => 'فیلد :attribute باید کمتر از :value باشد.',
        'string' => 'فیلد :attribute باید کمتر از :value کاراکتر داشته باشد.',
    ],
    'lte' => [
        'array' => 'فیلد :attribute نباید بیش از :value آیتم داشته باشد.',
        'file' => 'فیلد :attribute باید کمتر یا برابر با :value کیلوبایت باشد.',
        'numeric' => 'فیلد :attribute باید کمتر یا برابر با :value باشد.',
        'string' => 'فیلد :attribute باید کمتر یا برابر با :value کاراکتر باشد.',
    ],
    'mac_address' => 'فیلد :attribute باید یک آدرس MAC معتبر باشد.',
    'max' => [
        'array' => 'فیلد :attribute نباید بیش از :max آیتم داشته باشد.',
        'file' => 'فیلد :attribute نباید بزرگ‌تر از :max کیلوبایت باشد.',
        'numeric' => 'فیلد :attribute نباید بزرگ‌تر از :max باشد.',
        'string' => 'فیلد :attribute نباید بیش از :max کاراکتر داشته باشد.',
    ],
    'max_digits' => 'فیلد :attribute نباید بیش از :max رقم داشته باشد.',
    'mimes' => 'فیلد :attribute باید فایلی از نوع: :values باشد.',
    'mimetypes' => 'فیلد :attribute باید فایلی از نوع: :values باشد.',
    'min' => [
        'array' => 'فیلد :attribute باید حداقل :min آیتم داشته باشد.',
        'file' => 'فیلد :attribute باید حداقل :min کیلوبایت باشد.',
        'numeric' => 'فیلد :attribute باید حداقل :min باشد.',
        'string' => 'فیلد :attribute باید حداقل :min کاراکتر داشته باشد.',
    ],
    'min_digits' => 'فیلد :attribute باید حداقل :min رقم داشته باشد.',
    'missing' => 'فیلد :attribute باید غایب باشد.',
    'missing_if' => 'فیلد :attribute باید غایب باشد وقتی :other برابر با :value باشد.',
    'missing_unless' => 'فیلد :attribute باید غایب باشد مگر اینکه :other برابر با :value باشد.',
    'missing_with' => 'فیلد :attribute باید غایب باشد وقتی :values حاضر باشد.',
    'missing_with_all' => 'فیلد :attribute باید غایب باشد وقتی :values حاضر باشند.',
    'multiple_of' => 'فیلد :attribute باید مضربی از :value باشد.',
    'not_in' => 'مقدار انتخاب‌شده برای :attribute نامعتبر است.',
    'not_regex' => 'فرمت فیلد :attribute نامعتبر است.',
    'numeric' => 'فیلد :attribute باید یک عدد باشد.',
    'password' => [
        'letters' => 'فیلد :attribute باید حداقل یک حرف داشته باشد.',
        'mixed' => 'فیلد :attribute باید حداقل یک حرف بزرگ و یک حرف کوچک داشته باشد.',
        'numbers' => 'فیلد :attribute باید حداقل یک عدد داشته باشد.',
        'symbols' => 'فیلد :attribute باید حداقل یک نماد داشته باشد.',
        'uncompromised' => 'مقدار :attribute در یک نشت داده ظاهر شده است. لطفاً :attribute دیگری انتخاب کنید.',
    ],
    'present' => 'فیلد :attribute باید حاضر باشد.',
    'present_if' => 'فیلد :attribute باید حاضر باشد وقتی :other برابر با :value باشد.',
    'present_unless' => 'فیلد :attribute باید حاضر باشد مگر اینکه :other برابر با :value باشد.',
    'present_with' => 'فیلد :attribute باید حاضر باشد وقتی :values حاضر باشد.',
    'present_with_all' => 'فیلد :attribute باید حاضر باشد وقتی :values حاضر باشند.',
    'prohibited' => 'فیلد :attribute ممنوع است.',
    'prohibited_if' => 'فیلد :attribute ممنوع است وقتی :other برابر با :value باشد.',
    'prohibited_unless' => 'فیلد :attribute ممنوع است مگر اینکه :other در :values باشد.',
    'prohibits' => 'فیلد :attribute مانع حضور :other می‌شود.',
    'regex' => 'فرمت فیلد :attribute نامعتبر است.',
    'required' => 'فیلد :attribute الزامی است.',
    'required_array_keys' => 'فیلد :attribute باید شامل ورودی‌هایی برای: :values باشد.',
    'required_if' => 'فیلد :attribute الزامی است وقتی :other برابر با :value باشد.',
    'required_if_accepted' => 'فیلد :attribute الزامی است وقتی :other پذیرفته شده باشد.',
    'required_if_declined' => 'فیلد :attribute الزامی است وقتی :other رد شده باشد.',
    'required_unless' => 'فیلد :attribute الزامی است مگر اینکه :other در :values باشد.',
    'required_with' => 'فیلد :attribute الزامی است وقتی :values حاضر باشد.',
    'required_with_all' => 'فیلد :attribute الزامی است وقتی :values حاضر باشند.',
    'required_without' => 'فیلد :attribute الزامی است وقتی :values حاضر نباشد.',
    'required_without_all' => 'فیلد :attribute الزامی است وقتی هیچ‌کدام از :values حاضر نباشند.',
    'same' => 'فیلد :attribute باید با :other مطابقت داشته باشد.',
    'size' => [
        'array' => 'فیلد :attribute باید شامل :size آیتم باشد.',
        'file' => 'فیلد :attribute باید :size کیلوبایت باشد.',
        'numeric' => 'فیلد :attribute باید :size باشد.',
        'string' => 'فیلد :attribute باید :size کاراکتر باشد.',
    ],
    'starts_with' => 'فیلد :attribute باید با یکی از موارد زیر شروع شود: :values.',
    'string' => 'فیلد :attribute باید یک رشته باشد.',
    'timezone' => 'فیلد :attribute باید یک منطقه زمانی معتبر باشد.',
    'unique' => 'مقدار :attribute قبلاً استفاده شده است.',
    'uploaded' => 'بارگذاری :attribute ناموفق بود.',
    'uppercase' => 'فیلد :attribute باید با حروف بزرگ باشد.',
    'ulid' => 'فیلد :attribute باید یک ULID معتبر باشد.',
    'unique_encrypted' => ':attribute تکراری می باشد.',
    'url' => 'فیلد :attribute باید یک URL معتبر باشد.',
    'uuid' => 'فیلد :attribute باید یک UUID معتبر باشد.',
    'polymorphic_exists' => 'فیلد :attribute با مقدار :value در کلاس :model نامعتبر است.',
    'national_code' => ':attribute صحیح نمی باشد.',
    'own_student_with_school_session' => 'دانش آموز مورد انتخابی شما (:students) در این کلاس(:teacherFullName :dataTime) نمی باشند.',
    'own_student_with_lesson' => 'دانش آموز مورد انتخابی شما (:students) درس (:lesson) ندارد.',
    'school_session_access' => 'شما دسترسی به کلاس برگزار شده :value را ندارید.',
    'unique_teaching_report' => 'نمره نهایی دانش آموز (:student) قبلا ثبت گردیده است.',
    'check_podmany_teaching_report' => 'نمرات را با توجه به پودمانی بودن یا نبودن درس (:lesson_title) و نوبت ترم :term وارد نمایید',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'academic_level.title' => 'عنوان',
        'accurate' => 'دقت جستجو',
        'app' => 'برنامه',
        'bell.ended_at' => 'ساعت پایان',
        'bell.started_at' => 'ساعت شروع',
        'bell.title' => 'عنوان',
        'class_room.academic_level_id' => 'شماره یکتا پایه',
        'class_room.code' => 'کد',
        'class_room.major_id' => 'شماره یکتا رشته',
        'class_room.title' => 'عنوان',
        'dir' => 'پوشه',
        'ended_at' => 'تاریخ پایان',
        'error' => 'خطا',
        'filename' => 'نام فایل',
        'filters' => 'فیلتر',
        'first' => 'شروع رکورد',
        'grade' => 'نمره',
        'grades.*.grade' => 'نمره',
        'grades.*.id' => 'شماره یکتا',
        'grades.*.school_session_id' => 'شماره یکتا برگزاری کلاس',
        'grades.*.student_id' => 'شماره یکتا دانش آموز',
        'grades' => 'نمرات',
        'id' => 'شماره یکتا',
        'lesson.class_room_id' => 'شماره یکتا کلاس',
        'lesson.is_podmany' => 'پودمانی',
        'lesson.passing_grade' => 'نمره قبولی',
        'lesson.title' => 'عنوان',
        'major.title' => 'عنوان',
        'moral' => 'وضعیت اخلاقی',
        'morals.*.comment' => 'نظر',
        'morals.*.id' => 'شماره یکتا',
        'morals.*.moral' => 'توضیحات وضعیت اخلاقی',
        'morals.*.school_session_id' => 'شماره یکتا برگزاری کلاس',
        'morals.*.student_id' => 'شماره یکتا دانش آموز',
        'morals' => 'وضعیت اخلاقی',
        'name' => 'نام',
        'national_code' => 'کد ملی',
        'password' => 'رمز',
        'phone' => 'شماره موبایل',
        'presence.school_session_id' => 'شماره یکتا برگزاری کلاس',
        'presence.students.*.delay_reason' => 'دلیل تاخیر',
        'presence.students.*.early_exit_reason' => 'دلیل تعجیل',
        'presence.students.*.entry_time' => 'ساعت ورود',
        'presence.students.*.exit_time' => 'ساعت خروج',
        'presence.students.*.status' => 'وضعیت',
        'presence.students.*.student_id' => 'شماره یکتا دانش آموز',
        'presence.students' => 'دانش آموزان',
        'result.*' => 'نتیجه',
        'result' => 'نتیجه',
        'role.id' => 'شماره یکتا',
        'role.name' => 'عنوان',
        'role.permissions.*' => 'دسترسی',
        'role.permissions' => 'دسترسی‌ها',
        'role.title' => 'عنوان',
        'rows' => 'تعداد رکورد',
        'school_session.activity' => 'فعالیت',
        'school_session.comment' => 'نظر',
        'school_session.held' => 'برگزاری',
        'school_session.started_at' => 'تاریخ و ساعت شروع کلاس',
        'school_session.teacher_user_id' => 'شماره یکتا معلم',
        'school.code' => 'کد',
        'school.district' => 'ناحیه',
        'school.image' => 'لوگو',
        'school.province' => 'استان',
        'school.title' => 'عنوان',
        'school.type' => 'نوع',
        'sortField' => 'مرتب سازی',
        'sortOrder' => 'نوع مرتب سازی',
        'started_at' => 'تاریخ شروع',
        'student.class_room_id' => 'شماره یکتا کلاس',
        'student.delete_class_room_ids.*' => 'شماره یکتا کلاس',
        'student.delete_class_room_ids' => 'آرایه شماره یکتا کلاس',
        'student.first_name' => 'نام',
        'student.image' => 'عکس',
        'student.last_name' => 'نام خانوادگی',
        'student.national_code' => 'کد ملی',
        'student.parent_id' => 'شماره یکتا والدین',
        'teacher.personally_code' => 'کد پرسنلی',
        'teacher.user.active' => 'وضعیت',
        'teacher.user.name' => 'نام کاربری',
        'teacher.user.password' => 'رمز عبور',
        'teacher.user.profile.address' => 'آدرس',
        'teacher.user.profile.first_name' => 'نام',
        'teacher.user.profile.image' => 'عکس',
        'teacher.user.profile.last_name' => 'نام خانوادگی',
        'teacher.user.profile.national_code' => 'کد ملی',
        'teacher.user.profile.phone' => 'شماره همراه',
        'teacher.user.profile' => 'پروفایل',
        'teacher.user.role_id' => 'شماره یکتا نقش',
        'teaching_reports.*.final_grade' => 'نمره نهایی',
        'teaching_reports.*.genesis_grade' => 'نمره مستمر',
        'teaching_reports.*.id' => 'شماره یکتا',
        'teaching_reports.*.lesson_id' => 'شماره یکتا درس',
        'teaching_reports.*.parent_grade' => '',
        'teaching_reports.*.podmany_five_grade' => 'نمره پودمانی اول',
        'teaching_reports.*.podmany_four_grade' => 'نمره پودمانی دوم',
        'teaching_reports.*.podmany_one_grade' => 'نمره پودمانی سوم',
        'teaching_reports.*.podmany_three_grade' => 'نمره پودمانی چهارم',
        'teaching_reports.*.podmany_two_grade' => 'نمره پودمانی پنجم',
        'teaching_reports.*.student_id' => 'شماره یکتا دانش آموز',
        'teaching_reports.*.term' => 'نوبت',
        'teaching_reports.*' => 'نمرات',
        'teaching_reports' => 'نمرات',
        'terms.*.ended_at' => 'تاریخ پایان',
        'terms.*.started_at' => 'تاریخ شروع',
        'terms.*.term' => 'نوبت',
        'terms.*.title' => 'عنوان',
        'terms' => 'نوبت',
        'user_id' => 'شماره یکتا کاربر',
        'user.active' => 'وضعیت',
        'user.current_password' => 'رمز عبور فعلی',
        'user.id' => 'شماره یکتا کاربر',
        'user.name' => 'نام کاربری',
        'user.password' => 'رمز',
        'user.profile.address' => 'آدرس',
        'user.profile.first_name' => 'نام',
        'user.profile.image' => 'عکس',
        'user.profile.last_name' => 'نام خانوادگی',
        'user.profile.national_code' => 'کد ملی',
        'user.profile.phone' => 'شماره همراه',
        'user.profile' => 'پروفایل',
        'user.role_id' => 'شماره یکتا دسترسی',
        'user.username' => 'نام کاربری',
        'weekly_schedule.bell_id' => 'شماره یکتا زنگ',
        'weekly_schedule.bell_type' => 'نوع زنگ',
        'weekly_schedule.class_room_id' => 'شماره یکتا کلاس',
        'weekly_schedule.day' => 'روز هفته',
        'weekly_schedule.lesson_id' => 'شماره یکتا درس',
        'weekly_schedule.teacher_id' => 'شماره یکتا معلم',
        'xlsx' => 'فایل اکسل',
    ],

];
