@include('components.teaching-reports-report.teaching-reports-report-head')

<body>
    @foreach ($studentGrades as $studentGrade)
    @php
    $classRoom = $studentGrade['class_room'] ?? null;
    @endphp

    <div class="report-card">
        <!-- header -->
        <table class="header-table">
            <tr>
                <td style="width: 25%; font-size: 10pt;">
                    کد مدرسه: {{ $reportInfo['school_code'] }}<br>
                    استان: {{ $reportInfo['school_province'] }}<br>
                    ناحیه: {{ $reportInfo['school_district'] }}
                </td>
                <td class="header-center">
                    <img class="logo-box" src="{{ public_path('storage/schools/images/logo.png') }}" />

                    <p style="margin: 0;">{{ $reportInfo['school_title'] }}</p>
                </td>
                <td style="width: 25%; font-size: 10pt; text-align: left;">
                    سال: {{ $getYear() }}<br>
                    نوبت: {{ $getTerm() }}<br>
                    نوع: {{ $reportInfo['school_type'] }}
                </td>
            </tr>
        </table>

        <!-- information -->
        <table class="student-info-table">
            <tr>
                <td style="vertical-align: middle;">
                    <strong>کد کلاس:</strong> {{ $classRoom['code'] ?? '-' }}<br><br>
                    <strong>پایه:</strong> {{ $classRoom['academic_level']['title'] ?? '-' }}<br><br>
                    <strong>رشته:</strong> {{ $classRoom['major']['title'] ?? '-' }}<br><br>
                </td>
                <td style="vertical-align: middle;">
                    <strong>نام و نام خانوادگی:</strong> {{ $fullName($studentGrade) }}<br><br>
                    <strong>نام پدر:</strong> {{ $fatherName($studentGrade) }}<br><br>
                    <strong>کد ملی:</strong> {{ $studentGrade['national_code'] ?? '-' }}<br><br>
                </td>
                <td style="text-align: left;">
                    <div class="photo-container">
                        <!-- student image -->
                        @if (isset($studentGrade['image']))
                        <img
                            class="student-photo"
                            src="{{ storage_path('app/private/students/images/'. $studentGrade['image']['name']) }}" />
                        @else
                        <img
                            class="student-photo"
                            src="{{ resource_path('assets/images/avatar.png') }}" />
                        @endif
                    </div>
                </td>
            </tr>
        </table>

        <!-- table grades-->
        <table class="grades-table">
            <thead>
                <tr>
                    <th rowspan="2" style="width: 40px;">ردیف</th>
                    <th rowspan="2">کد درس</th>
                    <th rowspan="2">نام درس</th>
                    <th colspan="2">نمرات نوبت اول</th>
                    <th colspan="{{ $term != 2 ? 2 : 3 }}">نمرات دروس پودمانی</th>
                    <th rowspan="2">نتیجه</th>
                    <th rowspan="2">اساتید</th>
                </tr>
                <tr>
                    <th>مستمر</th>
                    <th>پایانی</th>

                    @if ($term != 2)
                    <th>پودمانی 1</th>
                    <th>پودمانی 2</th>
                    @else
                    <th>پودمانی 3</th>
                    <th>پودمانی 4</th>
                    <th>پودمانی 5</th>
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach ($studentGrade['teaching_reports'] as $idx => $teaching_report)
                <tr class={{$passingLesson($teaching_report)?'':'failed-row'}}>
                    <td>{{ $idx + 1 }}</td>
                    <td>{{ $teaching_report['lesson']['id'] ?? '-' }}</td>
                    <td>{{ $teaching_report['lesson']['title'] ?? '-' }}</td>
                    <td>{{ $teaching_report['genesis_grade'] ?? '-'}}</td>
                    <td>{{ $teaching_report['final_grade'] ?? '-' }}</td>

                    @if ($term != 2)
                    <td>{{ $teaching_report['podmany_one_grade'] ?? '-' }}</td>
                    <td>{{ $teaching_report['podmany_two_grade'] ?? '-'}}</td>
                    @else
                    <td>{{ $teaching_report['podmany_three_grade'] ?? '-'}}</td>
                    <td>{{ $teaching_report['podmany_four_grade'] ?? '-'}}</td>
                    <td>{{ $teaching_report['podmany_five_grade'] ?? '-'}}</td>
                    @endif

                    <td>{{ $passingLesson($teaching_report) ? 'قبول' : 'مردود'}}</td>
                    <td>{{ $fullNameTeachers($teaching_report['lesson']) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="gpa-box">
            معدل دوره: {{ $finalGrade($studentGrade['teaching_reports']) }}
        </div>

        <!-- signature -->
        <table class="signature-table">
            <tr>
                <td>مهر و امضای معاون اجرایی</td>
                <td>مهر و امضای مدیریت آموزشگاه</td>
            </tr>
            <tr>
                <td>...........................</td>
                <td>...........................</td>
            </tr>
        </table>
    </div>
    @endforeach

</body>