<?php

use App\Http\Controllers\TeacherController;
use Illuminate\Support\Facades\Route;


Route::group(['prefix' => 'teachers'], function () {
    Route::get('', [TeacherController::class, 'index']);

    Route::post('', [TeacherController::class, 'store']);

    Route::post('excel', [TeacherController::class, 'excelStore']);

    Route::group(['prefix' => '{id}'], function () {
        Route::get('show', [TeacherController::class, 'show']);

        Route::patch('', [TeacherController::class, 'update']);

        Route::delete('', [TeacherController::class, 'destroy']);
    });
});
