<?php

use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;


Route::group(['prefix' => 'users'], function () {
    Route::get('', [UserController::class, 'index']);

    Route::post('', [UserController::class, 'store']);

    Route::group(['prefix' => '{id}'], function () {
        Route::get('show', [UserController::class, 'show']);

        Route::patch('', [UserController::class, 'update']);

        Route::patch('status', [UserController::class, 'statusUpdate']);

        Route::delete('', [UserController::class, 'destroy']);
    });

    Route::group(['prefix' => 'me'], function () {
        Route::get('', [UserController::class, 'me']);

        Route::patch('change-password', [UserController::class, 'changePassword']);
    });
});
